<?php
/**
 * License limited to a single site, for use on another site please purchase a license for this module.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * @author    Dingedi.com
 * @copyright Copyright 2025 © Dingedi All right reserved
 * @license   http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *
 * @category  Dingedi PrestaShop Modules
 */

include dirname(__FILE__) . '/../../config/config.inc.php';

if (!defined('_PS_VERSION_')) {
    exit;
}

/* Check security token */
if (!Tools::isPHPCLI()) {
    require_once 'index.php';
    exit;
}

require_once 'src/Command/TranslateContentCron.php';

$from_lang = getopt('', ['from_lang:'])['from_lang'];
$dest_lang = getopt('', ['dest_lang:'])['dest_lang'];
$tables = getopt('', ['tables:'])['tables'];
$overwrite = isset(getopt('', ['overwrite:'])['overwrite']) ? getopt('', ['overwrite:'])['overwrite'] : 'off';
$range = isset(getopt('', ['range:'])['range']) ? getopt('', ['range:'])['range'] : 'off';
$type = getopt('', ['type:'])['type'];
$id_shop = getopt('', ['id_shop:'])['id_shop'];

TranslateContentCron::translate(
    $from_lang,
    $dest_lang,
    $tables,
    $overwrite,
    $range,
    $type,
    $id_shop
);

echo 'Data has been translated';
