<?php
/**
 * License limited to a single site, for use on another site please purchase a license for this module.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * @author    Dingedi.com
 * @copyright Copyright 2025 © Dingedi All right reserved
 * @license   http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *
 * @category  Dingedi PrestaShop Modules
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class DgThemesList
{
    /**
     * @return mixed[]
     */
    public static function getList()
    {
        $pattern = _PS_ALL_THEMES_DIR_ . '*/{config/theme.yml,config.xml}';

        $theme_config_files = glob($pattern, GLOB_BRACE);
        $themes = [];

        foreach ($theme_config_files as $path) {
            $theme_dir = (basename(dirname($path)) === 'config') ? dirname(dirname($path)) : dirname($path);
            $themes[basename($theme_dir)] = true;
        }

        return array_keys($themes);
    }

    /**
     * @param string $themeName
     * @param int $idLangTo
     * @return \DgThemeTranslatable16
     */
    public static function getObject($themeName, $idLangTo)
    {
        if (!in_array($themeName, self::getList())) {
            throw new Exception("The theme {$themeName} does not exist or cannot be loaded");
        }

        $langTo = Dingedi\PsTranslationsApi\DgTranslationTools::getLanguage($idLangTo);

        if (Dingedi\PsTools\DgShopInfos::isPrestaShop16()) {
            return new DgThemeTranslatable16($themeName, $langTo);
        } else {
            return new DgThemeTranslatable17($themeName, $langTo);
        }
    }
}
