<?php
/**
 * License limited to a single site, for use on another site please purchase a license for this module.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * @author    Dingedi.com
 * @copyright Copyright 2025 © Dingedi All right reserved
 * @license   http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *
 * @category  Dingedi PrestaShop Modules
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class Attribute_lang extends Dingedi\TablesTranslation\DgTableTranslatable
{
    /**
     * @var false|string
     */
    public $controller = 'AdminAttributesGroups';
    /**
     * @var string
     */
    public $table = 'attribute_lang';
    /**
     * @var string|false
     */
    public $object_model = 'Attribute';

    public function __construct()
    {
        $primary_key = 'id_attribute';

        $fields = ['name'];
        $fields_rewrite = [];
        $fields_tags = [];

        parent::__construct($this->table, $primary_key, $fields, $fields_rewrite, $fields_tags);
    }

    /**
     * @return string|null
     */
    public function getLabel()
    {
        return $this->l('Attributes');
    }

    /**
     * @param string $controller
     * @param bool $checkHasId
     * @return bool
     */
    public function supportController($controller, $checkHasId = true)
    {
        return parent::supportController($controller, $checkHasId) && Tools::getValue('id_attribute') !== false;
    }
}
