<?php
/**
 * License limited to a single site, for use on another site please purchase a license for this module.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * @author    Dingedi.com
 * @copyright Copyright 2025 © Dingedi All right reserved
 * @license   http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *
 * @category  Dingedi PrestaShop Modules
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

if (!class_exists('Ets_ept_product_lang')) {
    class Ets_ept_product_lang extends Dingedi\TablesTranslation\DgTableTranslatable
    {
        /**
         * @var string
         */
        public $table = 'ets_ept_product';
        /**
         * @var string|false
         */
        public $module = 'ets_extraproducttabs';

        public function __construct()
        {
            $primary_key = 'id_product';

            $fields = ['content', 'file_desc'];
            $fields_rewrite = [];
            $fields_tags = [];

            parent::__construct($this->table, $primary_key, $fields, $fields_rewrite, $fields_tags);
        }

        /**
         * @param mixed[] $objectSource
         * @param mixed[] $objectDest
         * @param \Dingedi\TablesTranslation\DgTableTranslation $class
         * @return bool
         */
        public function afterAction($objectSource, $objectDest, $class)
        {
            Module::getInstanceByName('ets_extraproducttabs')->_clearSmartyCacheProductTab($objectSource[$this->primary_key]);

            return true;
        }

        /**
         * @param mixed[] $objectSource
         * @param mixed[] $objectDest
         * @param \Dingedi\TablesTranslation\DgTableTranslation $class
         * @return mixed[]
         */
        public function beforeTranslateAndCheckAction($objectSource, $objectDest, $class)
        {
            $elems = $class->dgTableTranslatable->findAll([
                'id_product' => $objectSource['id_product'],
                'id_lang' => $objectSource['id_lang'],
            ]);

            $elemsToTranslate = $class->dgTableTranslatable->findAll([
                'id_product' => $objectSource['id_product'],
                'id_lang' => $objectDest['id_lang'],
            ]);

            foreach ($elems as $item) {
                $itemToTranslate = array_filter($elemsToTranslate, function ($arr) use ($item) {
                    return $arr['id_product'] === $item['id_product'] && $arr['id_ets_ept_tab'] === $item['id_ets_ept_tab'];
                });

                if (empty($itemToTranslate)) {
                    $itemToTranslate = $item;
                    $itemToTranslate['id_lang'] = $objectDest['id_lang'];
                    unset($itemToTranslate['id_ets_ept_product']);
                } else {
                    $itemToTranslate = array_values($itemToTranslate)[0];
                }

                $itemToTranslateCopy = $itemToTranslate;

                foreach ($this->getFields() as $field) {
                    if (
                        (trim($item[$field]) !== ''
                            && (trim($itemToTranslate[$field]) === '' || trim($itemToTranslate[$field]) === trim($item[$field]))
                        )

                        || $class->overwrite === true
                    ) {
                        $itemToTranslate[$field] = $class->_translate($item[$field]);
                    }
                }

                if (isset($itemToTranslate['id_ets_ept_product'])) {
                    if (!empty(array_diff_assoc($itemToTranslate, $itemToTranslateCopy))) {
                        Db::getInstance()->update(
                            $this->table,
                            [
                                'content' => \pSQL($itemToTranslate['content'], true),
                                'file_desc' => isset($itemToTranslate['file_desc']) ? \pSQL($itemToTranslate['file_desc'], true) : null,
                            ],
                            'id_ets_ept_product=' . (int) $itemToTranslate['id_ets_ept_product']
                        );
                    }
                } else {
                    Db::getInstance()->insert($this->table, $itemToTranslate);
                }
            }

            return $objectDest;
        }

        /**
         * @param mixed[] $objectSource
         * @param mixed[] $objectDest
         * @param \Dingedi\TablesTranslation\DgTableTranslation $class
         * @return bool
         */
        public function needTranslation($objectSource, $objectDest, $class)
        {
            return false;
        }
    }
}
