<?php
/**
 * License limited to a single site, for use on another site please purchase a license for this module.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * @author    Dingedi.com
 * @copyright Copyright 2025 © Dingedi All right reserved
 * @license   http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *
 * @category  Dingedi PrestaShop Modules
 */

use Dingedi\TablesTranslation\DgTableTranslation;

if (!defined('_PS_VERSION_')) {
    exit;
}

if (!class_exists('Claveicategorydescription_category_lang')) {
    class Claveicategorydescription_category_lang extends Dingedi\TablesTranslation\DgTableTranslatable
    {
        /**
         * @var string|false
         */
        public $controller = 'AdminClaveiCategoryDescription';
        /**
         * @var string|false
         */
        public $module = 'claveicategorydescription';
        /**
         * @var string
         */
        public $table = 'claveicategorydescription_category_lang';

        public function __construct()
        {
            $primary_key = 'id_claveicategorydescription_category';

            $fields = ['description'];
            $fields_rewrite = [
            ];
            $fields_tags = [];

            parent::__construct($this->table, $primary_key, $fields, $fields_rewrite, $fields_tags);
        }

        /**
         * @param mixed[] $objectSource
         * @param mixed[]|null $objectDest
         * @param \Dingedi\TablesTranslation\DgTableTranslation $class
         * @return bool
         */
        public function beforeTranslateItemStart($objectSource, $objectDest, $class)
        {
            if (empty($objectDest)) {
                Db::getInstance()->insert($this->table, [
                    'id_claveicategorydescription_category' => $objectSource['id_claveicategorydescription_category'],
                    'id_lang' => $class->to['id_lang'],
                    'description' => '',
                ]);
            }

            return true;
        }
    }
}
