<?php
/**
 * License limited to a single site, for use on another site please purchase a license for this module.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * @author    Dingedi.com
 * @copyright Copyright 2025 © Dingedi All right reserved
 * @license   http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *
 * @category  Dingedi PrestaShop Modules
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class DgModulesList
{
    /**
     * @var mixed[]
     */
    public static $certified = [
        'ps_facetedsearch',
        'blockreassurance',
        'ps_checkout',
        'ps_buybuttonlite',
        'ps_mbo',
        'psgdpr',
        'psaddonsconnect',
        'emarketing',
        'gamification',
        'welcome',
        'statsvisits',
        'statsstock',
        'statssearch',
        'statssales',
        'statsregistrations',
        'statsproduct',
        'statspersonalinfos',
        'statsorigin',
        'statsnewsletter',
        'statslive',
        'statsforecast',
        'statsequipment',
        'statsdata',
        'statscheckup',
        'statscatalog',
        'statscarrier',
        'statsbestvouchers',
        'statsbestsuppliers',
        'statsbestproducts',
        'statsbestcustomers',
        'statsbestcategories',
        'sekeywords',
        'pagesnotfound',
        'ps_wirepayment',
        'ps_themecusto',
        'ps_socialfollow',
        'ps_shoppingcart',
        'ps_sharebuttons',
        'ps_searchbar',
        'ps_mainmenu',
        'ps_linklist',
        'ps_languageselector',
        'ps_imageslider',
        'ps_featuredproducts',
        'ps_faviconnotificationbo',
        'ps_emailsubscription',
        'ps_customtext',
        'ps_customersignin',
        'ps_customeraccountlinks',
        'ps_currencyselector',
        'ps_contactinfo',
        'ps_checkpayment',
        'ps_categorytree',
        'ps_banner',
        'gsitemap',
        'gridhtml',
        'graphnvd3',
        'dashproducts',
        'dashgoals',
        'dashtrends',
        'dashactivity',
        'contactform',
    ];

    /**
     * @return mixed[]
     */
    public static function getList()
    {
        $modules = [];

        foreach (Module::getModulesOnDisk() as $module) {
            $enabled = Module::isEnabled($module->name);
            $installed = Module::isInstalled($module->name);

            if (Dingedi\PsTranslationsApi\DgTranslationTools::getModuleOnlyLoadInstalled() && !$installed
                || Dingedi\PsTranslationsApi\DgTranslationTools::getModuleOnlyLoadEnabled() && !$enabled) {
                continue;
            }

            $certified = false;

            try {
                $certified = Module::getInstanceByName($module->name)->author === 'PrestaShop';
            } catch (Exception $e) {
            }

            $modules[] = [
                'name' => $module->name,
                'type' => 'module',
                'certified' => in_array($module->name, DgModulesList::$certified) || $certified,
                'enabled' => $enabled,
            ];
        }

        return $modules;
    }

    /**
     * @param string $moduleName
     * @param int $idLangTo
     * @return \DgModuleTranslatable16
     */
    public static function getObject($moduleName, $idLangTo)
    {
        $langTo = Dingedi\PsTranslationsApi\DgTranslationTools::getLanguage($idLangTo);

        if (Dingedi\PsTools\DgShopInfos::isPrestaShop16()) {
            return new DgModuleTranslatable16($moduleName, $langTo);
        } else {
            return new DgModuleTranslatable17($moduleName, $langTo);
        }
    }
}
